package w83a.w83aUtilidades;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;

import java.util.Date;

import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 * @author 
 *
 */
public class W83aUtilidadesPdf{
	
	private W83aUtilidadesPdf(){}
	
	public static class HeaderFooter extends PdfPageEventHelper {    
        //Declaramos el pie de pgina como un Phrase
        Phrase pie = new Phrase();//NOPMD
        String idioma;//NOPMD
        String direccion;//NOPMD
        
        public HeaderFooter(String id, String dir){
        	idioma=id;
        	direccion=dir;
        }
     
        //Evento que se ejecuta al terminar una pgina
        public void onEndPage(PdfWriter writer, Document document) {
          try {
        	Rectangle rect = writer.getBoxSize("art");
        	Font helvetica = new Font(BaseFont.createFont(BaseFont.HELVETICA, "Cp1252", false), W83aClsConstantes.SIETE);
			pie = new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.label.pag",idioma,new String[]{String.valueOf(writer.getCurrentPageNumber())}),helvetica);
			ColumnText.showTextAligned(writer.getDirectContent(),
	                  Element.ALIGN_CENTER, new Phrase(direccion,helvetica),
	                  (rect.getLeft() + rect.getRight()) / 2, rect.getBottom() - W83aClsConstantes.VEINTE, 0);  
	        ColumnText.showTextAligned(writer.getDirectContent(),
	                  Element.ALIGN_RIGHT, pie,
	                  rect.getRight(), rect.getBottom() - W83aClsConstantes.VEINTE, 0);   
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

          
        }   
      }
	
    public static void ponerCabecera (ByteArrayOutputStream baos, String provincia, String idioma, String modo){   
        try{
        	W83aClsTrazas.trazaError(null,"comienzo mtodo ponerCabecera->",null);
        	PdfReader reader = new PdfReader(new ByteArrayInputStream(((ByteArrayOutputStream) baos).toByteArray()));
        	W83aClsTrazas.trazaError(null,"instanciando reader",null);
        	int n = reader.getNumberOfPages();
        	W83aClsTrazas.trazaError(null,"nmero de pginas"+n,null);
        	PdfStamper stamp = new PdfStamper(reader,  baos);
        	W83aClsTrazas.trazaError(null,"instanciando stamp",null);
        	int i = 1;
        	PdfContentByte under;
        	PdfContentByte over;
        	Image logo;
        	W83aClsTrazas.trazaError(null,"modo="+modo,null);
        	if ("horizontal".equals(modo)){
        		W83aClsTrazas.trazaError(null,"en horizontal",null);
        		W83aClsTrazas.trazaError(null,"ruta->"+Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_IMAGES")+"logoGV.jpg",null);
        		logo= Image.getInstance(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_IMAGES")+"logoGV.jpg");
        		W83aClsTrazas.trazaError(null,"logo",null);
        		logo.scaleToFit(300, 300);
        		W83aClsTrazas.trazaError(null,"logo scale",null);
        	}
        	else{
        		W83aClsTrazas.trazaError(null,"en vertical",null);
        		W83aClsTrazas.trazaError(null,"ruta->"+Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_IMAGES")+"logoGVvertical.jpg",null);
        		logo= Image.getInstance(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_IMAGES")+"logoGVvertical.jpg");
        		W83aClsTrazas.trazaError(null,"logo",null);
        		logo.scaleToFit(275, 275);
        		W83aClsTrazas.trazaError(null,"logo scale",null);
        	}
        	
        	logo.setAlignment(Element.ALIGN_MIDDLE);
        	W83aClsTrazas.trazaError(null,"logo alineado",null);
        	logo.setSpacingAfter((float)W83aClsConstantes.VEINTE);
        	W83aClsTrazas.trazaError(null,"logo con espacio",null);
        	if ("horizontal".equals(modo)){
        		W83aClsTrazas.trazaError(null,"en horizontal",null);
        		logo.setAbsolutePosition((float)272, (float)535);//para encajar la imagen en la cabecera de pagina 272
        		W83aClsTrazas.trazaError(null,"logo absolute position",null);
        	}
        	else{
        		W83aClsTrazas.trazaError(null,"en vertical",null);
        		logo.setAbsolutePosition((float)162, (float)795);//para encajar la imagen en la cabecera de pagina 162
        		W83aClsTrazas.trazaError(null,"logo absolute position",null);
        	}
        	Date date = new Date();
        	W83aClsTrazas.trazaError(null,"date instanciado",null);
        	SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
        	W83aClsTrazas.trazaError(null,"formateo fecha cast",null);
        	String fecha = sdf.format(date);
        	W83aClsTrazas.trazaError(null,"fecha="+fecha,null);

        	SimpleDateFormat sdfEuskera=new SimpleDateFormat("yyyy/MM/dd");
        	W83aClsTrazas.trazaError(null,"formateo fecha eusk",null);
        	String fechaEuskera = sdfEuskera.format(date);
        	W83aClsTrazas.trazaError(null,"fechaEuskera="+fechaEuskera,null);
        	
        	StringBuffer tituloImagenEs = new StringBuffer();
        	W83aClsTrazas.trazaError(null,"tituloImagenEs instanciado",null);
        	StringBuffer tituloImagenEu = new StringBuffer();
        	W83aClsTrazas.trazaError(null,"tituloImagenEu instanciado",null);
        	
        	W83aClsTrazas.trazaError(null,"provincia="+provincia,null);
        	if(W83aClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        		W83aClsTrazas.trazaError(null,"entrado araba",null);
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma));
            	W83aClsTrazas.trazaError(null,"lit1="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma),null);
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma));
            	W83aClsTrazas.trazaError(null,"lit2="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma),null);
        	}else if(W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
            	W83aClsTrazas.trazaError(null,"entrado sscc",null);
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu",idioma));
            	W83aClsTrazas.trazaError(null,"lit3="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu",idioma),null);
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es",idioma));
            	W83aClsTrazas.trazaError(null,"lit4="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es",idioma),null);
        	}else if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
            	W83aClsTrazas.trazaError(null,"entrado gipuzkoa",null);
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
            	W83aClsTrazas.trazaError(null,"lit5="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma),null);
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma));
            	W83aClsTrazas.trazaError(null,"lit6="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma),null);
        	}
            else if(W83aClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
            	W83aClsTrazas.trazaError(null,"bizkaia",null);
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma));        	
            	W83aClsTrazas.trazaError(null,"lit7="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma),null);
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma));        	
            	W83aClsTrazas.trazaError(null,"lit8="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma),null);
            }
        	
        	while (i < n + 1)  {    
        		W83aClsTrazas.trazaError(null,"dentro de while",null);
        		// Watermark under the existing page
            	under = stamp.getUnderContent(i);
            	over = stamp.getOverContent(i);
            	
            	W83aClsTrazas.trazaError(null,"under="+under,null);
            	W83aClsTrazas.trazaError(null,"over="+over,null);
            	
            	StringBuffer txt= new StringBuffer();//NOPMD
            	W83aClsTrazas.trazaError(null,"txt instanciado",null);
            	W83aClsTrazas.trazaError(null,"idioma="+idioma,null);
            	if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
            		W83aClsTrazas.trazaError(null,"castellano",null);
            		txt.append(fecha);
            	}
            	else{
            		W83aClsTrazas.trazaError(null,"euskera",null);
            		txt.append(fechaEuskera);
            	}
            	W83aClsTrazas.trazaError(null,"txt anadido",null);
	            // Crear fuente debe ser una base
	            BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, "Cp1252", false);
	            W83aClsTrazas.trazaError(null,"bf instanciado",null);
	            //   comienzo a escribir texto
	            under.beginText();
	            W83aClsTrazas.trazaError(null,"beginText",null);
	            //  la fuente a utilizar
	            under.setFontAndSize(bf, W83aClsConstantes.SIETE);
	            W83aClsTrazas.trazaError(null,"fuente y tam anadido",null);
	            // la posiciisBon en la que va a ser colocado el texto
	            if ("horizontal".equals(modo)){
	            	W83aClsTrazas.trazaError(null,"horizontal",null);
	            	under.setTextMatrix((float)725,(float)565);
	            }
	            else{
	            	W83aClsTrazas.trazaError(null,"vertical",null);
	            	under.setTextMatrix((float)535,(float)825);
	            }
	            W83aClsTrazas.trazaError(null,"under setTextMatrix",null);
	            // Escribo el texto
	            under.showText(txt.toString());
	            W83aClsTrazas.trazaError(null,"under showText",null);
	            // Indico que termine de agregar texto
	            under.endText();
	            W83aClsTrazas.trazaError(null,"under endText",null);
            	
            	under.beginText();
            	W83aClsTrazas.trazaError(null,"under beginText",null);
            	under.setFontAndSize(bf, W83aClsConstantes.SIETE);
            	W83aClsTrazas.trazaError(null,"under setFontAndSize",null);
            	if ("horizontal".equals(modo)){
            		W83aClsTrazas.trazaError(null,"horizontal",null);
            		under.setTextMatrix((float)50,(float)565);
            	}
            	else{
            		W83aClsTrazas.trazaError(null,"vertical",null);
            		under.setTextMatrix((float)20,(float)825);
            	}
            	W83aClsTrazas.trazaError(null,"under setTextMatrix",null);
            	under.showText(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.eleccionesSindicales",idioma));
            	W83aClsTrazas.trazaError(null,"under showText="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.eleccionesSindicales",idioma),null);
            	under.endText();
            	W83aClsTrazas.trazaError(null,"under endText",null);
            	
              	// coloca la imagen sobre el margen
            	over.addImage(logo);
            	W83aClsTrazas.trazaError(null,"over addImage="+logo,null);
            	over.beginText();
            	W83aClsTrazas.trazaError(null,"over beginText="+logo,null);
                BaseFont bf_times = BaseFont.createFont(BaseFont.HELVETICA_BOLD, "Cp1252", false);
                W83aClsTrazas.trazaError(null,"bf_times instanciado",null);
                BaseFont bf_timescur = BaseFont.createFont(BaseFont.HELVETICA_OBLIQUE, "Cp1252", false);
                W83aClsTrazas.trazaError(null,"bf_timescur instanciado",null);
                over.setFontAndSize(bf_times, W83aClsConstantes.SIETE); 
                W83aClsTrazas.trazaError(null,"over setFontAndSize",null);
                if ("horizontal".equals(modo)){
                	W83aClsTrazas.trazaError(null,"horizontal",null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_eu",idioma), 282, 538, 0);
                	W83aClsTrazas.trazaError(null,"lit1="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_eu",idioma),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_eu",idioma), 282, 530, 0);
                	W83aClsTrazas.trazaError(null,"lit2="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_eu",idioma),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_es",idioma), 450, 538, 0);
                	W83aClsTrazas.trazaError(null,"lit3="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_es",idioma),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_es",idioma), 450, 530, 0);
                	W83aClsTrazas.trazaError(null,"lit4="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_es",idioma),null);
                	over.setFontAndSize(bf_timescur, W83aClsConstantes.SIETE);
                	W83aClsTrazas.trazaError(null,"bf_timescur",null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEu.toString(), 282, 522, 0);
                	W83aClsTrazas.trazaError(null,"lit5="+tituloImagenEu.toString(),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEs.toString(), 450, 522, 0);   
                	W83aClsTrazas.trazaError(null,"lit6="+tituloImagenEs.toString(),null);
                }
                else{
                	W83aClsTrazas.trazaError(null,"vertical",null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_eu",idioma), 171, 798, 0);
                	W83aClsTrazas.trazaError(null,"lit1="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_eu",idioma),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_eu",idioma), 171, 790, 0);
                	W83aClsTrazas.trazaError(null,"lit2="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_eu",idioma),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_es",idioma), 325, 798, 0);
                	W83aClsTrazas.trazaError(null,"lit3="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme1Abr_es",idioma),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_es",idioma), 325, 790, 0);
                	W83aClsTrazas.trazaError(null,"lit4="+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme2Abr_es",idioma),null);
                	over.setFontAndSize(bf_timescur, W83aClsConstantes.SIETE);
                	W83aClsTrazas.trazaError(null,"bf_timescur",null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEu.toString(), 171, 782, 0);
                	W83aClsTrazas.trazaError(null,"showTextAligned="+tituloImagenEu.toString(),null);
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEs.toString(), 325, 782, 0);   
                	W83aClsTrazas.trazaError(null,"showTextAligned="+tituloImagenEs.toString(),null);
                }
                
                over.endText();
                W83aClsTrazas.trazaError(null,"over endText",null);
                i++;
                W83aClsTrazas.trazaError(null,"i="+i,null);
        	}
        	stamp.close();
        	W83aClsTrazas.trazaError(null,"stamp close",null);
        	
        }catch(Exception e){
        	W83aClsTrazas.trazaError(null,"error ponerCabecera->"+e.getMessage(),e.getCause());
        }
        
    }


}